<?php
/**
 * Enhanced General Settings Page
 * 
 * Combines existing Delcampe settings with WPLister-style layout
 * for better organization and user experience
 * 
 * @package WooCommerce_Delcampe_Integration
 * @version 1.10.13.0
 * @since 1.10.13.0
 */

// Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Get current settings
$api_key = get_option('delcampe_api_key', '');
$sync_interval = get_option('delcampe_sync_interval', '15');
$auto_import_orders = get_option('delcampe_auto_import_orders', 'yes');
$auto_sync = get_option('delcampe_auto_sync', 'yes');
$handle_stock = get_option('delcampe_handle_stock', 'yes');
$create_orders = get_option('delcampe_create_orders', 'yes');
$background_sync = get_option('delcampe_background_sync', 'fifteen_min');
$push_changes = get_option('delcampe_push_changes', '0');

// Order status settings
$shipped_order_status = get_option('delcampe_shipped_order_status', 'completed');
$paid_order_status = get_option('delcampe_paid_order_status', 'processing');
$unpaid_order_status = get_option('delcampe_unpaid_order_status', 'on-hold');

// Get license status
$license_manager = Delcampe_License_Manager::get_instance();
$license_type = $license_manager->get_license_type();
$is_licensed = $license_manager->is_license_valid();

// Check if sync is active
$has_api_key = !empty($api_key);
$sync_active = $has_api_key && $auto_sync === 'yes' && $handle_stock === 'yes';
?>

<style type="text/css">
    .delcampe-settings-page .postbox {
        margin-bottom: 20px;
    }
    .delcampe-settings-page .postbox h3 {
        padding: 10px 12px;
        margin: 0;
        font-size: 14px;
        line-height: 1.4;
        border-bottom: 1px solid #eee;
    }
    .delcampe-settings-page .inside {
        padding: 12px;
        margin: 0;
    }
    .delcampe-settings-page .form-table th {
        width: 250px;
        padding-left: 12px;
    }
    .delcampe-settings-page .text_label {
        display: inline-block;
        width: 240px;
        vertical-align: top;
        padding-top: 5px;
    }
    .delcampe-settings-page select.select {
        min-width: 200px;
    }
    .delcampe-settings-page .desc {
        display: block;
        margin-top: 5px;
        margin-left: 245px;
        color: #666;
        font-style: italic;
        font-size: 12px;
    }
    .delcampe-settings-page .metabox-holder {
        padding-top: 0;
    }
    #side-sortables .postbox {
        min-width: 280px;
    }
    #side-sortables .inside {
        padding: 10px;
    }
    .sync-status-active {
        color: #46b450;
        font-weight: bold;
    }
    .sync-status-inactive {
        color: #dc3232;
    }
    .sync-status-partial {
        color: #ffb900;
    }
    .field-disabled {
        opacity: 0.6;
        pointer-events: none;
    }
    .pro-notice {
        background: #fff3cd;
        border-left: 4px solid #ffb900;
        padding: 8px 12px;
        margin: 10px 0;
    }
</style>

<div class="wrap delcampe-settings-page">
    
    <form method="post" id="settingsForm" action="options.php">
        <?php 
        settings_fields('delcampe_general_settings');
        ?>
        
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                
                <!-- Main Content -->
                <div id="post-body-content">
                    
                    <!-- API Configuration Box -->
                    <div class="postbox">
                        <h3 class="hndle"><span><?php _e('API Configuration', 'wc-delcampe-integration'); ?></span></h3>
                        <div class="inside">
                            
                            <label for="delcampe_api_key" class="text_label">
                                <?php _e('Delcampe API Key', 'wc-delcampe-integration'); ?>
                                <span class="required">*</span>
                            </label>
                            <input type="password" 
                                   id="delcampe_api_key" 
                                   name="delcampe_api_key" 
                                   value="<?php echo esc_attr($api_key); ?>" 
                                   class="regular-text"
                                   placeholder="Enter your Delcampe API key">
                            <p class="desc">
                                <?php _e('Enter your Delcampe API key. You can find this in your', 'wc-delcampe-integration'); ?>
                                <a href="https://www.delcampe.net/en_GB/collectables/store-settings/" target="_blank">
                                    <?php _e('Delcampe account settings', 'wc-delcampe-integration'); ?>
                                </a>
                            </p>
                            
                            <?php if ($has_api_key): ?>
                                <div style="margin-top: 10px; margin-left: 245px;">
                                    <button type="button" 
                                            class="button button-secondary" 
                                            id="test-delcampe-connection">
                                        <?php _e('Test Connection', 'wc-delcampe-integration'); ?>
                                    </button>
                                    <span id="test-connection-result" style="margin-left: 10px;"></span>
                                </div>
                            <?php endif; ?>
                            
                        </div>
                    </div>
                    
                    <!-- Background Tasks Box -->
                    <div class="postbox">
                        <h3 class="hndle"><span><?php _e('Background Tasks', 'wc-delcampe-integration'); ?></span></h3>
                        <div class="inside">
                            
                            <label for="delcampe_background_sync" class="text_label">
                                <?php _e('Update interval', 'wc-delcampe-integration'); ?>
                            </label>
                            <select id="delcampe_background_sync" name="delcampe_background_sync" class="select">
                                <option value="five_min" <?php selected($background_sync, 'five_min'); ?>>
                                    <?php _e('5 minutes', 'wc-delcampe-integration'); ?>
                                </option>
                                <option value="ten_min" <?php selected($background_sync, 'ten_min'); ?>>
                                    <?php _e('10 minutes', 'wc-delcampe-integration'); ?>
                                </option>
                                <option value="fifteen_min" <?php selected($background_sync, 'fifteen_min'); ?>>
                                    <?php _e('15 minutes', 'wc-delcampe-integration'); ?> (<?php _e('default', 'wc-delcampe-integration'); ?>)
                                </option>
                                <option value="thirty_min" <?php selected($background_sync, 'thirty_min'); ?>>
                                    <?php _e('30 minutes', 'wc-delcampe-integration'); ?>
                                </option>
                                <option value="hourly" <?php selected($background_sync, 'hourly'); ?>>
                                    <?php _e('Hourly', 'wc-delcampe-integration'); ?>
                                </option>
                                <option value="daily" <?php selected($background_sync, 'daily'); ?>>
                                    <?php _e('Daily', 'wc-delcampe-integration'); ?> (<?php _e('not recommended', 'wc-delcampe-integration'); ?>)
                                </option>
                                <option value="" <?php selected($background_sync, ''); ?>>
                                    <?php _e('Manually', 'wc-delcampe-integration'); ?> (<?php _e('not recommended', 'wc-delcampe-integration'); ?>)
                                </option>
                                <option value="external" <?php selected($background_sync, 'external'); ?>>
                                    <?php _e('Use external cron job', 'wc-delcampe-integration'); ?> (<?php _e('recommended', 'wc-delcampe-integration'); ?>)
                                </option>
                            </select>
                            <p class="desc">
                                <?php _e('Select how often to run background jobs, like checking for new sales on Delcampe.', 'wc-delcampe-integration'); ?>
                            </p>
                            
                            <div style="clear: both; margin-top: 15px;">
                                <label for="delcampe_push_changes" class="text_label">
                                    <?php _e('Push changes to Delcampe', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_push_changes" name="delcampe_push_changes" class="select">
                                    <option value="0" <?php selected($push_changes, '0'); ?>>
                                        <?php _e('Off', 'wc-delcampe-integration'); ?> (<?php _e('default', 'wc-delcampe-integration'); ?>)
                                    </option>
                                    <option value="1" <?php selected($push_changes, '1'); ?>>
                                        <?php _e('Yes, push changes automatically', 'wc-delcampe-integration'); ?>
                                    </option>
                                </select>
                                <p class="desc">
                                    <?php _e('Enable this to revise changed items automatically in the background.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div style="clear: both; margin-top: 15px;" class="<?php echo !$is_licensed ? 'field-disabled' : ''; ?>">
                                <label for="delcampe_handle_stock" class="text_label">
                                    <?php _e('Synchronize sales', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_handle_stock" name="delcampe_handle_stock" class="select" <?php echo !$is_licensed ? 'disabled' : ''; ?>>
                                    <option value="yes" <?php selected($handle_stock, 'yes'); ?>>
                                        <?php _e('Yes', 'wc-delcampe-integration'); ?> (<?php _e('recommended', 'wc-delcampe-integration'); ?>)
                                    </option>
                                    <option value="no" <?php selected($handle_stock, 'no'); ?>>
                                        <?php _e('No', 'wc-delcampe-integration'); ?>
                                    </option>
                                </select>
                                <?php if (!$is_licensed): ?>
                                    <p class="desc">
                                        <?php _e('To enable this option, please activate Delcampe Sync with a valid license.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php else: ?>
                                    <p class="desc">
                                        <?php _e('Automatically reduce the stock level in WooCommerce when an item is sold on Delcampe, and vice versa.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                            
                        </div>
                    </div>
                    
                    <!-- WooCommerce Orders Box -->
                    <div class="postbox">
                        <h3 class="hndle"><span><?php _e('WooCommerce Orders', 'wc-delcampe-integration'); ?></span></h3>
                        <div class="inside">
                            
                            <div class="<?php echo !$is_licensed ? 'field-disabled' : ''; ?>">
                                <label for="delcampe_create_orders" class="text_label">
                                    <?php _e('Create orders', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_create_orders" name="delcampe_create_orders" class="select" <?php echo !$is_licensed ? 'disabled' : ''; ?>>
                                    <option value="yes" <?php selected($create_orders, 'yes'); ?>>
                                        <?php _e('Yes', 'wc-delcampe-integration'); ?> (<?php _e('recommended', 'wc-delcampe-integration'); ?>)
                                    </option>
                                    <option value="no" <?php selected($create_orders, 'no'); ?>>
                                        <?php _e('No', 'wc-delcampe-integration'); ?>
                                    </option>
                                </select>
                                <p class="desc">
                                    <?php _e('Enable this to create orders in WooCommerce from sales on Delcampe.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div style="clear: both; margin-top: 15px;" class="<?php echo !$is_licensed ? 'field-disabled' : ''; ?>">
                                <label for="delcampe_shipped_order_status" class="text_label">
                                    <?php _e('Status for shipped orders', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_shipped_order_status" name="delcampe_shipped_order_status" class="select" <?php echo !$is_licensed ? 'disabled' : ''; ?>>
                                    <?php if (function_exists('wc_get_order_statuses')): ?>
                                        <?php foreach (wc_get_order_statuses() as $status_slug => $status_name): ?>
                                            <?php $status_slug = str_replace('wc-', '', $status_slug); ?>
                                            <option value="<?php echo esc_attr($status_slug); ?>" <?php selected($shipped_order_status, $status_slug); ?>>
                                                <?php echo esc_html($status_name); ?>
                                                <?php if ('completed' == $status_slug): ?> (<?php _e('default', 'wc-delcampe-integration'); ?>) <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <option value="completed" <?php selected($shipped_order_status, 'completed'); ?>>
                                            <?php _e('Completed', 'wc-delcampe-integration'); ?>
                                        </option>
                                        <option value="processing" <?php selected($shipped_order_status, 'processing'); ?>>
                                            <?php _e('Processing', 'wc-delcampe-integration'); ?>
                                        </option>
                                    <?php endif; ?>
                                </select>
                                <p class="desc">
                                    <?php _e('Select the WooCommerce order status for orders which have been marked as shipped on Delcampe.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div style="clear: both; margin-top: 15px;" class="<?php echo !$is_licensed ? 'field-disabled' : ''; ?>">
                                <label for="delcampe_paid_order_status" class="text_label">
                                    <?php _e('Status for paid orders', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_paid_order_status" name="delcampe_paid_order_status" class="select" <?php echo !$is_licensed ? 'disabled' : ''; ?>>
                                    <?php if (function_exists('wc_get_order_statuses')): ?>
                                        <?php foreach (wc_get_order_statuses() as $status_slug => $status_name): ?>
                                            <?php $status_slug = str_replace('wc-', '', $status_slug); ?>
                                            <option value="<?php echo esc_attr($status_slug); ?>" <?php selected($paid_order_status, $status_slug); ?>>
                                                <?php echo esc_html($status_name); ?>
                                                <?php if ('processing' == $status_slug): ?> (<?php _e('default', 'wc-delcampe-integration'); ?>) <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <option value="completed" <?php selected($paid_order_status, 'completed'); ?>>
                                            <?php _e('Completed', 'wc-delcampe-integration'); ?>
                                        </option>
                                        <option value="processing" <?php selected($paid_order_status, 'processing'); ?>>
                                            <?php _e('Processing', 'wc-delcampe-integration'); ?>
                                        </option>
                                    <?php endif; ?>
                                </select>
                                <p class="desc">
                                    <?php _e('Select the WooCommerce order status for orders where payment has been completed on Delcampe.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div style="clear: both; margin-top: 15px;" class="<?php echo !$is_licensed ? 'field-disabled' : ''; ?>">
                                <label for="delcampe_unpaid_order_status" class="text_label">
                                    <?php _e('Status for unpaid orders', 'wc-delcampe-integration'); ?>
                                </label>
                                <select id="delcampe_unpaid_order_status" name="delcampe_unpaid_order_status" class="select" <?php echo !$is_licensed ? 'disabled' : ''; ?>>
                                    <?php if (function_exists('wc_get_order_statuses')): ?>
                                        <?php foreach (wc_get_order_statuses() as $status_slug => $status_name): ?>
                                            <?php $status_slug = str_replace('wc-', '', $status_slug); ?>
                                            <option value="<?php echo esc_attr($status_slug); ?>" <?php selected($unpaid_order_status, $status_slug); ?>>
                                                <?php echo esc_html($status_name); ?>
                                                <?php if ('on-hold' == $status_slug): ?> (<?php _e('default', 'wc-delcampe-integration'); ?>) <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <option value="on-hold" <?php selected($unpaid_order_status, 'on-hold'); ?>>
                                            <?php _e('On Hold', 'wc-delcampe-integration'); ?>
                                        </option>
                                        <option value="pending" <?php selected($unpaid_order_status, 'pending'); ?>>
                                            <?php _e('Pending', 'wc-delcampe-integration'); ?>
                                        </option>
                                    <?php endif; ?>
                                </select>
                                <p class="desc">
                                    <?php _e('Select the WooCommerce order status for orders which are still unpaid on Delcampe.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
                <!-- /post-body-content -->
                
                <!-- Sidebar -->
                <div id="postbox-container-1" class="postbox-container">
                    <div id="side-sortables" class="meta-box-sortables">
                        
                        <!-- Sync Status Box -->
                        <div class="postbox">
                            <h3 class="hndle"><span><?php _e('Sync Status', 'wc-delcampe-integration'); ?></span></h3>
                            <div class="inside">
                                
                                <?php if (!$has_api_key): ?>
                                    <p class="sync-status-inactive">
                                        <?php _e('No Delcampe account has been set up yet.', 'wc-delcampe-integration'); ?>
                                    </p>
                                    <p>
                                        <?php _e('Please enter your API key to enable synchronization.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php elseif (!$is_licensed): ?>
                                    <p class="sync-status-partial">
                                        <?php _e('Limited sync available.', 'wc-delcampe-integration'); ?>
                                    </p>
                                    <p>
                                        <?php _e('Activate your license to enable full synchronization features.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php elseif ($sync_active): ?>
                                    <p class="sync-status-active">
                                        <?php _e('Sync is enabled.', 'wc-delcampe-integration'); ?>
                                    </p>
                                    <p>
                                        <?php _e('Sales will be synchronized between WooCommerce and Delcampe.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php else: ?>
                                    <p class="sync-status-inactive">
                                        <?php _e('Sync is currently disabled.', 'wc-delcampe-integration'); ?>
                                    </p>
                                    <p>
                                        <?php _e('Delcampe and WooCommerce sales will not be synchronized!', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php endif; ?>
                                
                                <hr style="margin: 15px -10px;">
                                
                                <div style="text-align: center;">
                                    <input type="submit" 
                                           name="submit" 
                                           id="submit" 
                                           class="button button-primary" 
                                           value="<?php _e('Save Settings', 'wc-delcampe-integration'); ?>">
                                </div>
                                
                            </div>
                        </div>
                        
                        <!-- Update Schedule Box -->
                        <?php if ($background_sync && $background_sync !== ''): ?>
                        <div class="postbox">
                            <h3 class="hndle"><span><?php _e('Update Schedule', 'wc-delcampe-integration'); ?></span></h3>
                            <div class="inside">
                                
                                <?php if (wp_next_scheduled('delcampe_process_sync_queue')): ?>
                                    <p>
                                        <?php _e('Next scheduled update', 'wc-delcampe-integration'); ?>
                                        <?php 
                                        $next_run = wp_next_scheduled('delcampe_process_sync_queue');
                                        echo human_time_diff($next_run, current_time('timestamp')) . ' ';
                                        echo $next_run < current_time('timestamp') ? __('ago', 'wc-delcampe-integration') : '';
                                        ?>
                                    </p>
                                    <p class="description">
                                        <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $next_run); ?>
                                    </p>
                                <?php elseif ($background_sync === 'external'): ?>
                                    <p>
                                        <?php _e('Background updates are handled by an external cron job.', 'wc-delcampe-integration'); ?>
                                    </p>
                                    <p>
                                        <code style="font-size: 11px; word-break: break-all;">
                                            <?php echo esc_url(admin_url('admin-ajax.php?action=delcampe_run_scheduled_tasks')); ?>
                                        </code>
                                    </p>
                                <?php else: ?>
                                    <p>
                                        <?php _e('Background updates are disabled.', 'wc-delcampe-integration'); ?>
                                    </p>
                                <?php endif; ?>
                                
                                <?php if (wp_next_scheduled('delcampe_import_orders_cron')): ?>
                                    <hr style="margin: 10px -10px;">
                                    <p>
                                        <?php _e('Order import', 'wc-delcampe-integration'); ?>
                                        <?php 
                                        $next_order_run = wp_next_scheduled('delcampe_import_orders_cron');
                                        echo human_time_diff($next_order_run, current_time('timestamp')) . ' ';
                                        echo $next_order_run < current_time('timestamp') ? __('ago', 'wc-delcampe-integration') : '';
                                        ?>
                                    </p>
                                <?php endif; ?>
                                
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Quick Actions Box -->
                        <div class="postbox">
                            <h3 class="hndle"><span><?php _e('Quick Actions', 'wc-delcampe-integration'); ?></span></h3>
                            <div class="inside">
                                
                                <p>
                                    <a href="<?php echo admin_url('admin.php?page=delcampe-sync'); ?>" 
                                       class="button button-secondary" style="width: 100%;">
                                        <?php _e('View Dashboard', 'wc-delcampe-integration'); ?>
                                    </a>
                                </p>
                                
                                <?php if ($has_api_key): ?>
                                <p>
                                    <a href="<?php echo admin_url('admin.php?page=delcampe-listings'); ?>" 
                                       class="button button-secondary" style="width: 100%;">
                                        <?php _e('Manage Listings', 'wc-delcampe-integration'); ?>
                                    </a>
                                </p>
                                
                                <p>
                                    <a href="<?php echo admin_url('admin.php?page=delcampe-orders'); ?>" 
                                       class="button button-secondary" style="width: 100%;">
                                        <?php _e('View Orders', 'wc-delcampe-integration'); ?>
                                    </a>
                                </p>
                                <?php endif; ?>
                                
                                <p>
                                    <a href="<?php echo admin_url('admin.php?page=delcampe-settings&tab=license'); ?>" 
                                       class="button button-secondary" style="width: 100%;">
                                        <?php _e('License Settings', 'wc-delcampe-integration'); ?>
                                    </a>
                                </p>
                                
                            </div>
                        </div>
                        
                    </div>
                </div>
                <!-- /postbox-container-1 -->
                
            </div>
            <!-- /post-body -->
        </div>
        <!-- /poststuff -->
        
    </form>
    
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    
    // Test API connection
    $('#test-delcampe-connection').on('click', function() {
        var $button = $(this);
        var $result = $('#test-connection-result');
        
        $button.prop('disabled', true);
        $result.html('<span class="spinner is-active" style="float: none;"></span>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'test_delcampe_connection',
                nonce: '<?php echo wp_create_nonce('test_delcampe_connection'); ?>'
            },
            success: function(response) {
                $button.prop('disabled', false);
                
                if (response.success) {
                    $result.html('<span style="color: #46b450;">✓ ' + response.data.message + '</span>');
                } else {
                    $result.html('<span style="color: #dc3232;">✗ ' + response.data.message + '</span>');
                }
            },
            error: function() {
                $button.prop('disabled', false);
                $result.html('<span style="color: #dc3232;">✗ Connection test failed</span>');
            }
        });
    });
    
    // Update field states based on license
    function updateFieldStates() {
        var isLicensed = <?php echo $is_licensed ? 'true' : 'false'; ?>;
        
        if (!isLicensed) {
            $('.field-disabled select').prop('disabled', true);
        }
    }
    
    updateFieldStates();
    
});
</script>