<?php
/**
 * Admin Settings Page Template
 *
 * Renders the main settings interface for the Delcampe Integration plugin.
 * Handles API configuration, general settings, and core functionality options.
 *
 * @package WooCommerce_Delcampe_Integration
 * @subpackage Admin/Templates
 * @version 1.0.8.0
 * @since 1.0.0
 */

// Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Initialize settings
$api_key = get_option('delcampe_api_key', '');
$sync_interval = get_option('delcampe_sync_interval', '30');
$last_sync = get_option('delcampe_last_sync', false);
?>

<div class="wrap">
    <h1><?php echo esc_html__('Delcampe Integration Settings', 'wc-delcampe-integration'); ?></h1>

    <?php settings_errors(); ?>

    <form method="post" action="options.php">
        <?php
        settings_fields('delcampe_settings');
        do_settings_sections('delcampe_settings');
        ?>

        <div class="card">
            <h2><?php echo esc_html__('API Configuration', 'wc-delcampe-integration'); ?></h2>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="delcampe_api_key"><?php echo esc_html__('API Key', 'wc-delcampe-integration'); ?></label>
                    </th>
                    <td>
                        <input type="password" 
                               id="delcampe_api_key" 
                               name="delcampe_api_key" 
                               value="<?php echo esc_attr($api_key); ?>" 
                               class="regular-text">
                        <p class="description">
                            <?php echo esc_html__('Enter your Delcampe API key. You can find this in your Delcampe account settings.', 'wc-delcampe-integration'); ?>
                        </p>
                    </td>
                </tr>
            </table>
        </div>

        <div class="card">
            <h2><?php echo esc_html__('Synchronization Settings', 'wc-delcampe-integration'); ?></h2>
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="delcampe_sync_interval">
                            <?php echo esc_html__('Sync Interval (minutes)', 'wc-delcampe-integration'); ?>
                        </label>
                    </th>
                    <td>
                        <input type="number" 
                               id="delcampe_sync_interval" 
                               name="delcampe_sync_interval" 
                               value="<?php echo esc_attr($sync_interval); ?>" 
                               min="5" 
                               max="1440" 
                               class="small-text">
                        <p class="description">
                            <?php echo esc_html__('How often should the plugin check for updates? (5-1440 minutes)', 'wc-delcampe-integration'); ?>
                        </p>
                    </td>
                </tr>
                <?php if ($last_sync) : ?>
                <tr>
                    <th scope="row"><?php echo esc_html__('Last Sync', 'wc-delcampe-integration'); ?></th>
                    <td>
                        <p><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $last_sync)); ?></p>
                    </td>
                </tr>
                <?php endif; ?>
            </table>
        </div>

        <?php submit_button(); ?>
    </form>

    <div class="card">
        <h2><?php echo esc_html__('Test Connection', 'wc-delcampe-integration'); ?></h2>
        <p>
            <button type="button" 
                    class="button button-secondary" 
                    id="test-delcampe-connection">
                <?php echo esc_html__('Test API Connection', 'wc-delcampe-integration'); ?>
            </button>
            <span class="spinner" style="float: none; margin-top: 0;"></span>
        </p>
        <div id="connection-test-result"></div>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    $('#test-delcampe-connection').on('click', function() {
        var $button = $(this);
        var $spinner = $button.next('.spinner');
        var $result = $('#connection-test-result');

        $button.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'test_delcampe_connection',
                nonce: '<?php echo wp_create_nonce('test_delcampe_connection'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="notice notice-success"><p>' + response.data + '</p></div>');
                } else {
                    $result.html('<div class="notice notice-error"><p>' + response.data + '</p></div>');
                }
            },
            error: function() {
                $result.html('<div class="notice notice-error"><p><?php echo esc_js(__('Connection test failed. Please try again.', 'wc-delcampe-integration')); ?></p></div>');
            },
            complete: function() {
                $button.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
});
</script>