<?php
// Simple autoloader for Delcampe plugin classes
// Maps class names like Delcampe_Sync_Handler → includes/class-delcampe-sync-handler.php

if (!defined('ABSPATH')) {
    exit;
}

spl_autoload_register(function ($class) {
    if (strpos($class, 'Delcampe_') !== 0 && strpos($class, 'DWC_') !== 0) {
        return;
    }

    $normalized = strtolower(str_replace('_', '-', $class));
    // Delcampe_Sync_Handler → class-delcampe-sync-handler.php
    $file = 'class-' . str_replace('delcampe-', 'delcampe-', $normalized) . '.php';

    $paths = array(
        plugin_dir_path(__FILE__),                             // includes/
        plugin_dir_path(__FILE__) . 'profiles/',               // includes/profiles/
        plugin_dir_path(__FILE__) . 'tables/',                 // includes/tables/
        dirname(__FILE__, 2) . '/admin/',                      // admin/
    );

    foreach ($paths as $base) {
        $candidate = rtrim($base, '/\r\n') . '/' . $file;
        if (file_exists($candidate)) {
            require_once $candidate;
            return;
        }
    }
});

