<?php
/**
 * Deferred License Hooks Registration
 *
 * Registers license-related hooks after init to avoid early translation loading
 *
 * @package WC_Delcampe_Integration
 * @version 1.10.5.10
 * @since   1.10.5.10
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Initialize license hooks after init
 *
 * @since 1.10.5.10
 */
function delcampe_init_license_hooks() {
    // Admin bar menu hook
    add_action('admin_bar_menu', 'delcampe_add_license_admin_bar', 100);
    
    // Admin body class filter
    add_filter('admin_body_class', 'delcampe_add_license_body_class');
    
    // Admin CSS hook
    add_action('admin_head', 'delcampe_license_admin_css');
    
    // User capabilities filter
    add_filter('user_has_cap', 'delcampe_filter_capabilities', 10, 3);
    
    // License redirect check
    add_action('current_screen', 'delcampe_license_redirect');
}

// Hook to init with priority 10 to ensure it runs after textdomain is loaded
add_action('init', 'delcampe_init_license_hooks', 10);