<?php
/**
 * Listing API Sync Logger Integration
 * 
 * This file contains the modifications needed to integrate the sync logger
 * into the existing listing API class.
 * 
 * Add these modifications to class-delcampe-listing-api.php
 */

// At the top of create_listing method, after line 143, add:
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-delcampe-sync-logger.php';
$sync_logger = Delcampe_Sync_Logger::get_instance();

// Log sync start with product details
$product_data = array(
    'sku' => $product->get_sku(),
    'title' => $product->get_name(),
    'price' => $product->get_price(),
    'personal_reference' => $product->get_sku() // or generate a unique one
);
$sync_logger->log_sync_start($product_id, $product_data);

// In submit_listing method, after line 573 (before making the API call), add:
$sync_logger->log_api_request($this->endpoints['add_item'], $post_data);

// In submit_listing method, after line 595 (after getting response), add:
$sync_logger->log_api_response($status_code, $body);

// In process_listing_response method, replace the success section (around line 237-256) with:
if ( ! empty( $response['success'] ) && $response['success'] === true ) {
    // Success - update product status
    $integration->update_sync_status( $product_id, 'active' );
    
    // Store personal reference if available
    if ( ! empty( $response['personal_reference'] ) ) {
        update_post_meta( $product_id, '_delcampe_personal_reference', sanitize_text_field( $response['personal_reference'] ) );
    }
    
    // Store listing ID if available
    $listing_id = '';
    if ( ! empty( $response['id'] ) ) {
        $listing_id = sanitize_text_field( $response['id'] );
        update_post_meta( $product_id, '_delcampe_listing_id', $listing_id );
    }
    
    // Log success with sync logger
    $sync_logger->log_sync_complete(
        $product_id, 
        true, 
        $listing_id,
        isset($response['message']) ? $response['message'] : 'Listing created successfully'
    );
    
    // Log success with regular logger
    $this->log( sprintf( 'Successfully created listing for product: %d', $product_id ), 'info' );
    
    // Trigger action for other plugins
    do_action( 'delcampe_listing_created', $product_id, $response );
    
} else {
    // The API accepted the request but we should note the status
    $message = isset($response['message']) ? $response['message'] : 'No success flag in response';
    
    $sync_logger->log_sync_complete(
        $product_id,
        false,
        '',
        $message
    );
    
    $this->log( 
        sprintf( 'API accepted request but no success flag for product %d. Response: %s', 
            $product_id, 
            print_r( $response, true ) 
        ), 
        'warning' 
    );
    
    // Mark as pending since it was accepted
    $integration->update_sync_status( $product_id, 'pending' );
    
    // Store personal reference for tracking
    update_post_meta( $product_id, '_delcampe_personal_reference', sanitize_text_field( $listing_data['personal_reference'] ) );
}

// For error handling, add sync logger calls in appropriate catch blocks:
$sync_logger->log_sync_error($product_id, $error_message, array('wp_error_code' => $error_code));