<?php
/**
 * Plugin Constants and Version Information
 * 
 * Centralized location for all plugin metadata and version numbers.
 * Update this file when releasing new versions.
 * 
 * @package     WooCommerce_Delcampe_Integration
 * @subpackage  Core
 * @since       1.1.0.0
 * @version     1.10.33.0
 * 
 * @author      SOS Services
 * @copyright   2024 SOS Services
 * @license     Proprietary
 * 
 * Version History:
 * 1.10.5.16 - Fixed listing status logic and added webhook setup guide
 *           - Only marks listings as 'sold' when all quantity is sold
 *           - Updates remaining quantity in database on each sale
 *           - Created comprehensive WEBHOOK_SETUP_GUIDE.md
 * 1.10.5.15 - Implemented real-time order processing via webhook
 *           - Added proper handle_item_sold() implementation in webhook handler
 *           - Created create_order_from_webhook() method in Order Manager
 *           - Made import_single_order() public for webhook access
 *           - Orders now process immediately when sold on Delcampe
 *           - Inventory is automatically reduced on webhook order creation
 * 1.10.5.14 - Fixed shipping models log to use plugin logging system
 *           - Changed error_log() calls to delcampe_log() for proper log file routing
 * 1.10.5.13 - Fixed final translation loading warnings in updater and sync handler
 *           - Modified get_plugin_data() to not translate plugin headers during early load
 *           - Removed translation from cron schedule display name
 * 1.10.5.12 - Fixed additional early hook registration issues
 *           - Deferred Delcampe_Setup_Notice::init() to 'init' hook
 *           - Deferred Delcampe_Admin_Page::init() to 'init' hook
 * 1.10.5.11 - Fixed remaining translation loading warnings
 *           - Fixed wrong text domain in stamp profile fields ('delcampe-integration' to 'wc-delcampe-integration')
 *           - Fixed wrong text domain in import page ('wc-delcampe' to 'wc-delcampe-integration')
 *           - Added text domain loading check for plugin action links and row meta
 *           - Removed translation calls from activation hook
 * 1.10.5.10 - Fixed license and WooCommerce check notices to load after init
 * 1.10.5.7 - Fixed profile-related translation warnings
 *          - Removed translation calls from stamp profile field arrays
 *          - Added translated versions of profile field functions for display
 *          - Updated all profile field displays to use translated functions
 * 1.10.5.6 - Fixed translation loading warnings appearing in logs
 *          - Deferred menu registration translations to avoid early loading
 *          - Fixed singleton class instantiation timing
 * 1.10.5.5 - Menu reorganization for improved user experience
 *          - Moved Cleanup functionality to Inventory → Cleanup tab
 *          - Moved License page to Settings → License tab
 *          - Removed standalone menu items for cleaner navigation
 *          - Updated documentation to reflect new menu structure
 * 1.10.5.4 - Fixed update system for better license handling
 *          - Download URLs now always provided from update server
 *          - License validation happens during download attempt, not URL generation
 *          - Prevents "A valid URL was not provided" error
 *          - Better error messages when license is invalid
 *          - Update server only provides files, no authentication
 * 1.10.5.3 - Fixed listing closure to use correct DELETE method
 *          - Changed from POST with XML body to DELETE with query parameters
 *          - API endpoint uses query string: ?token=X&reason=Y&priority=1
 *          - Follows actual Delcampe API documentation for ItemDelete
 *          - Success returns minimal response, confirmation via notification
 *          - 404 errors now properly fall back to local-only closure
 * 1.10.5.2 - Corrected listing closure API implementation (incorrect)
 *          - Fixed HTTP method from DELETE to POST per Delcampe API specification
 *          - Added proper XML request body with Seller_Item_Close_UnSold structure
 *          - Added correct Content-Type: application/xml header
 *          - API now properly accepts closure requests
 *          - Note: Closures are processed asynchronously via notifications
 * 1.10.5.1 - Hotfix for listing closure with fallback to local-only mode
 *          - Added automatic fallback when Delcampe API returns HTML instead of XML
 *          - Created delcampe_mark_listing_ended() function for local status updates
 *          - Added filter 'delcampe_use_local_close_only' to force local-only mode
 *          - Fixed logging calls to use delcampe_log function properly
 *          - Users can now mark listings as ended locally when API doesn't support it
 * 1.10.5.0 - Added comprehensive listing closure functionality
 *          - Implemented close/end listing feature directly in plugin interface
 *          - Added "Close" button in Sync Management tab for active listings
 *          - Added "Close Listing" button in product edit meta box
 *          - Created Delcampe_Listing_Closer class for handling closures
 *          - Updated Delcampe_Listing_API with proper close_listing implementation
 *          - Added AJAX handlers for seamless listing closure
 *          - Updates both product meta and listings table on closure
 * 1.10.4.0 - Fixed image access issues for complex network setups
 *          - Created image proxy system for serving images via local endpoints
 *          - Added REST API endpoint /wp-json/delcampe/v1/image/{id}
 *          - Added rewrite endpoint /delcampe-image/{id}
 *          - Created image URL filter system for dev environments
 *          - Added diagnostic tools for network and DNS troubleshooting
 *          - Fixed redirect loop issues preventing Delcampe from accessing images
 * 1.10.3.0 - Enhanced API response handling for 201 Created status
 *          - Full support for new Delcampe API response format
 *          - Proper handling of Seller_Item_Add notification type
 *          - Support for warning messages in successful responses
 *          - Updated sync logger and viewer for better diagnostics
 * 1.10.2.0 - Added closed listings synchronization and cleanup functionality
 *          - New "Sync Closed Listings" feature to sync items closed on Delcampe
 *          - Added "Cleanup All Listings" to check all listings against Delcampe
 *          - Fixed database column issues (status vs listing_status, updated_at)
 *          - Enhanced error handling for listings without Delcampe IDs
 * 1.10.1.0 - Fixed Orders menu visibility and loading issues
 * 1.10.0.0 - Major order management system update
 * 1.9.0.5 - Fixed blank shipping model names in dropdown
 *         - Shipping models now use 'type' field as fallback when 'name' field is empty
 *         - Ensures shipping dropdown displays actual model names instead of blank entries
 * 1.9.0.4 - Simplified update system for better user experience
 *         - Removed complex authentication during downloads
 *         - License validation now happens locally
 *         - Shows informative message for unlicensed users (like Slider Revolution)
 *         - Direct download URL for licensed users without authentication
 * 1.9.0.3 - Fixed shipping profile integration and sync queue processing
 *         - Added shipping_model_id column to profiles table
 *         - Fixed profile save to properly store shipping model selection
 *         - Changed sync queue to process all items instead of limiting to 5
 *         - Added database migration for existing installations
 * 1.9.0.2 - Rebranded plugin and updated links
 *         - Changed plugin name from "WooCommerce Delcampe Integration" to "Delcampe Sync"
 *         - Updated plugin description to be more concise and professional
 *         - Fixed plugin URI to https://www.sos-tech.ca/plugins/delcampe-sync
 *         - Fixed documentation link to https://www.sos-tech.ca/docs/delcampe-sync
 *         - Fixed support link to https://www.sos-tech.ca/support/delcampe-sync
 * 1.9.0.1 - Fixed bulk publish profile dropdown not showing profiles
 *         - Removed incorrect WHERE clause checking for non-existent profile_status column
 *         - Profile dropdown now correctly displays all available profiles
 * 1.6.2.1 - Fixed duplicate inventory menu and missing render_page() method
 *         - Removed duplicate menu registration in inventory admin class
 *         - Added render_page() method for compatibility
 *         - Updated plugin header with correct author information
 * 1.6.2.0 - Fixed database schema to include personal_reference column
 *         - Added database migration for existing installations
 *         - Fixed sync handler to properly handle personal_reference field
 *         - Updated version numbers across all affected files
 *         - Added comprehensive comments explaining the fix
 * 1.6.1.0 - Fixed Import Existing Listings button functionality in listings admin
 *         - Removed conflicting debug JavaScript from listings admin page
 *         - Enhanced sync handler with custom debug logging to wp-content/uploads/delcampe-debug.log
 *         - Added comprehensive error handling and JSON response headers
 *         - Updated all affected component version numbers for consistency
 * 1.6.0.3 - Fixed duplicate JavaScript issue for import existing listings button
 *         - Removed inline JavaScript that was conflicting with external JS file
 *         - Updated version numbers across all affected files
 *         - Added comprehensive comments throughout sync handler
 * 1.6.0.2 - Added import existing listings functionality
 *         - Updated sync handler to create listings table records
 *         - Added button to import products that were synced before listings table existed
 * 1.6.0.1 - Fixed listings admin initialization and menu display method
 *         - Fixed duplicate instantiation of listings admin class
 *         - Updated admin menu to properly handle listings page display
 *         - Added proper initialization method for listings admin
 * 1.6.0.0 - Added comprehensive listings management system
 *         - Created listings model with full database structure
 *         - Implemented listings table display similar to wp-lister-ebay
 *         - Added listings admin interface with bulk actions
 *         - Created listing statuses (prepared, verified, published, etc.)
 *         - Added preview and edit functionality for listings
 *         - Implemented lock/unlock mechanism for listings
 *         - Added product meta box for Delcampe listings
 *         - Created CSS and JavaScript for listings interface
 * 1.5.0.0 - Added comprehensive inventory management system
 *         - Implemented real-time stock synchronization between WooCommerce and Delcampe
 *         - Added automatic stock reduction when Delcampe orders are imported
 *         - Created inventory monitoring with low stock and out of stock alerts
 *         - Added inventory check tool to compare stock levels across platforms
 *         - Implemented bulk inventory sync and update functionality
 *         - Created dedicated inventory admin interface with statistics
 *         - Added inventory sync logging and alert system
 *         - Implemented oversell prevention mechanism
 * 1.4.0.0 - Added comprehensive order management system
 *         - Implemented order import from Delcampe to WooCommerce
 *         - Added bi-directional order status synchronization
 *         - Created order admin interface with tabbed navigation
 *         - Added automatic order import via cron
 *         - Implemented customer creation from Delcampe buyers
 *         - Added order statistics and reporting
 *         - Created database tables for order tracking
 * 1.3.0.1 - Fixed shipping models API parsing
 *         - Corrected XML structure parsing for shipping models
 *         - Fixed case sensitivity in API endpoint (shippingModels)
 * 1.3.0.0 - Added comprehensive shipping functionality
 *         - Implemented shipping models manager for Delcampe integration
 *         - Added shipping configuration interface
 *         - Integrated shipping into profiles system
 * 1.2.2.0 - Updated API implementation to match actual Delcampe API
 *         - Fixed authentication to use POST /seller endpoint
 *         - Fixed listing creation to use form data instead of XML
 * 1.2.1.0 - Added Listing API and Sync Handler modules
 *         - Implemented actual listing creation functionality
 *         - Added queue-based sync processing
 * 1.2.0.0 - Added product integration with profiles
 *         - Products can now be assigned Delcampe profiles
 *         - Added bulk actions for profile management
 * 1.1.5.0 - Completed profiles functionality with working category selection
 * 1.1.4.3 - Removed direct category selection, using only saved categories
 * 1.1.4.2 - Fixed asset path for CSS and JS files
 * 1.1.4.1 - Fixed text domain consistency and AJAX handlers
 * 1.1.4.0 - Enhanced profiles with stamp-specific fields and description builder
 * 1.1.3.0 - Added profile-based category mapping system
 * 1.1.2.1 - Fixed translation loading issue on activation
 * 1.1.2.0 - Updated version numbers across all files with enhanced documentation
 * 1.1.1.1 - Fixed version synchronization issues
 * 1.1.1.0 - Fixed translation loading and version display
 * 1.1.0.0 - Major refactor with tabbed interface
 */

// Exit if accessed directly to prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Plugin Version Information
 * 
 * @since 1.0.0
 */
define('DELCAMPE_PLUGIN_VERSION', '1.10.37.0');
define('DELCAMPE_PLUGIN_NAME', 'Delcampe Sync');
define('DELCAMPE_PLUGIN_SLUG', 'delcampe-sync');

/**
 * Plugin Metadata
 * 
 * @since 1.0.0
 */
define('DELCAMPE_PLUGIN_URI', 'https://www.sos-tech.ca/plugins/delcampe-sync');
define('DELCAMPE_AUTHOR', 'SOS Services');
define('DELCAMPE_AUTHOR_URI', 'https://www.sos-tech.ca');

/**
 * Internationalization Settings
 * 
 * @since 1.0.0
 */
define('DELCAMPE_TEXT_DOMAIN', 'wc-delcampe-integration');
define('DELCAMPE_DOMAIN_PATH', '/languages');

/**
 * Minimum System Requirements
 * 
 * @since 1.0.0
 */
define('DELCAMPE_MIN_PHP', '7.0');
define('DELCAMPE_MIN_WP', '5.0');
define('DELCAMPE_MIN_WC', '3.0');

/**
 * Delcampe API Configuration
 * 
 * @since 1.0.0
 */
define('DELCAMPE_API_BASE_URL', 'https://rest.delcampe.net');
define('DELCAMPE_API_URL', 'https://rest.delcampe.net'); // Alternative constant for backward compatibility
define('DELCAMPE_API_FORMAT', 'XML'); // All Delcampe API responses are in XML format

/**
 * User Agent for API Calls
 * Used to identify our plugin when making API requests
 * 
 * @since 1.0.0
 */
define('DELCAMPE_USER_AGENT', 'Delcampe-WooCommerce-Integration/' . DELCAMPE_PLUGIN_VERSION);

/**
 * Cache Duration Settings
 * 
 * @since 1.0.0
 */
define('DELCAMPE_TOKEN_EXPIRY', 30 * MINUTE_IN_SECONDS); // Auth token expires after 30 minutes
define('DELCAMPE_CATEGORY_CACHE_DURATION', 12 * HOUR_IN_SECONDS); // Categories cached for 12 hours

/**
 * Database Table Names (without WordPress prefix)
 * The actual table names will have the WordPress prefix prepended
 * 
 * @since 1.0.0
 */
define('DELCAMPE_TABLE_SELECTED_CATEGORIES', 'delcampe_selected_categories');
define('DELCAMPE_TABLE_CATEGORY_MAPPING', 'delcampe_category_mapping');
define('DELCAMPE_TABLE_PROFILES', 'delcampe_profiles');
define('DELCAMPE_TABLE_ORDERS', 'delcampe_orders');
define('DELCAMPE_TABLE_ORDER_FEES', 'delcampe_order_fees');
define('DELCAMPE_TABLE_INVENTORY_SYNC', 'delcampe_inventory_sync');
define('DELCAMPE_TABLE_INVENTORY_ALERTS', 'delcampe_inventory_alerts');
define('DELCAMPE_TABLE_LISTINGS', 'delcampe_listings');

/**
 * WordPress Transient Keys
 * Used for temporary data storage
 * 
 * @since 1.0.0
 */
define('DELCAMPE_TOKEN_TRANSIENT', 'delcampe_auth_token');
define('DELCAMPE_CATEGORIES_TRANSIENT', 'delcampe_categories');
define('DELCAMPE_MAPPING_CACHE_KEY', 'delcampe_category_mapping_cache');
define('DELCAMPE_PROFILES_CACHE_KEY', 'delcampe_profiles_cache');
define('DELCAMPE_SHIPPING_MODELS_CACHE_KEY', 'delcampe_shipping_models_cache');

/**
 * WordPress Option Keys
 * Used for persistent plugin settings
 * 
 * @since 1.0.0
 */
define('DELCAMPE_API_KEY_OPTION', 'delcampe_api_key');
define('DELCAMPE_LOGGING_OPTION', 'delcampe_enable_logging');
define('DELCAMPE_VERSION_OPTION', 'delcampe_plugin_version');
define('DELCAMPE_AUTO_SYNC_INVENTORY_OPTION', 'delcampe_auto_sync_inventory');
define('DELCAMPE_INVENTORY_CHECK_FREQUENCY_OPTION', 'delcampe_inventory_check_frequency');
define('DELCAMPE_LOW_STOCK_ALERT_OPTION', 'delcampe_low_stock_alert');
define('DELCAMPE_PREVENT_OVERSELL_OPTION', 'delcampe_prevent_oversell');
define('DELCAMPE_ORDER_IMPORT_ENABLED_OPTION', 'delcampe_order_import_enabled');
define('DELCAMPE_ORDER_IMPORT_FREQUENCY_OPTION', 'delcampe_order_import_frequency');
define('DELCAMPE_LAST_ORDER_IMPORT_OPTION', 'delcampe_last_order_import');

/**
 * Log File Paths
 * 
 * @since 1.0.0
 * @since 1.10.1.0 Changed log location from uploads to dedicated logs directory
 */
define('DELCAMPE_LOG_DIR', WP_CONTENT_DIR . '/delcampe-logs');
define('DELCAMPE_LOG_FILE', DELCAMPE_LOG_DIR . '/delcampe-sync.log');
define('DELCAMPE_DEBUG_LOG_FILE', DELCAMPE_LOG_DIR . '/delcampe-debug.log'); // Added in v1.6.1.0
// Dedicated publish audit log (request/response for create/update)
if (!defined('DELCAMPE_PUBLISH_LOG_FILE')) {
    define('DELCAMPE_PUBLISH_LOG_FILE', DELCAMPE_LOG_DIR . '/delcampe-publish-audit.log');
}
// Toggle for publish audit logging (heavy). Default off; enable via constant, option, or filter.
if (!defined('DELCAMPE_ENABLE_PUBLISH_AUDIT')) {
    define('DELCAMPE_ENABLE_PUBLISH_AUDIT', false);
}
// Force API publish (debug) — default off
if (!defined('DELCAMPE_FORCE_API_PUBLISH')) {
    define('DELCAMPE_FORCE_API_PUBLISH', false);
}

// Delcampe API call audit log (single-line per HTTP call)
if (!defined('DELCAMPE_CALLS_LOG_FILE')) {
    define('DELCAMPE_CALLS_LOG_FILE', DELCAMPE_LOG_DIR . '/delcalls.log');
}
if (!defined('DELCAMPE_ENABLE_CALL_LOG')) {
    // Enabled by default to help measure call volume; can be turned off via constant/option/filter.
    define('DELCAMPE_ENABLE_CALL_LOG', true);
}

/**
 * Admin Menu Slugs
 * Used for WordPress admin menu registration
 * 
 * @since 1.0.0
 */
define('DELCAMPE_MENU_MAIN', 'delcampe');
define('DELCAMPE_MENU_SETTINGS', 'delcampe-settings');
define('DELCAMPE_MENU_PROFILES', 'delcampe-profiles');
define('DELCAMPE_MENU_ORDERS', 'delcampe-orders');
define('DELCAMPE_MENU_INVENTORY', 'delcampe-inventory');
define('DELCAMPE_MENU_LISTINGS', 'delcampe-listings');
define('DELCAMPE_MENU_IMPORT', 'delcampe-import');
define('DELCAMPE_MENU_TEST_SYNC', 'delcampe_test_sync');

/**
 * Default Configuration Values
 * 
 * @since 1.0.0
 */
define('DELCAMPE_DEFAULT_BATCH_SIZE', 10);
define('DELCAMPE_DEFAULT_SYNC_INTERVAL', 'daily');
define('DELCAMPE_DEFAULT_INVENTORY_CHECK_INTERVAL', 'daily');
define('DELCAMPE_DEFAULT_LOW_STOCK_THRESHOLD', 5);
define('DELCAMPE_TEST_CATEGORY_ID', '80'); // Test category for sync testing

/**
 * WordPress Cron Hook Names
 * 
 * @since 1.2.1.0
 */
define('DELCAMPE_SYNC_CRON_HOOK', 'delcampe_sync_cron');
define('DELCAMPE_PROCESS_QUEUE_CRON_HOOK', 'delcampe_process_sync_queue');
define('DELCAMPE_IMPORT_ORDERS_CRON_HOOK', 'delcampe_import_orders_cron');
define('DELCAMPE_INVENTORY_CHECK_CRON_HOOK', 'delcampe_inventory_check_cron');

/**
 * Listing Status Constants
 * 
 * @since 1.6.0.0
 */
define('DELCAMPE_LISTING_STATUS_PREPARED', 'prepared');
define('DELCAMPE_LISTING_STATUS_VERIFIED', 'verified');
define('DELCAMPE_LISTING_STATUS_PUBLISHED', 'published');
define('DELCAMPE_LISTING_STATUS_CHANGED', 'changed');
define('DELCAMPE_LISTING_STATUS_ENDED', 'ended');
define('DELCAMPE_LISTING_STATUS_SOLD', 'sold');
define('DELCAMPE_LISTING_STATUS_ARCHIVED', 'archived');

/**
 * Debug Mode Setting
 * Set to true to enable detailed debug logging
 * 
 * @since 1.6.2.1
 */
define('DELCAMPE_DEBUG_MODE', false);

/**
 * Asset Loading Configuration
 * Controls whether to load minified assets in production
 * 
 * @since 1.6.2.1
 */
define('DELCAMPE_USE_MINIFIED_ASSETS', !DELCAMPE_DEBUG_MODE);

/**
 * Get plugin header for main plugin file
 * This can be used to generate the plugin header dynamically
 * 
 * @return string Plugin header comment block
 * @since  1.1.1.1
 * @version 1.6.2.1
 */
function delcampe_get_plugin_header() {
    return "/**
 * Plugin Name: " . DELCAMPE_PLUGIN_NAME . "
 * Plugin URI:  " . DELCAMPE_PLUGIN_URI . "
 * Description: A foundational plugin for bi-directional synchronization between WooCommerce and Delcampe.
 * Version:     " . DELCAMPE_PLUGIN_VERSION . "
 * Author:      " . DELCAMPE_AUTHOR . "
 * Author URI:  " . DELCAMPE_AUTHOR_URI . "
 *
 * Text Domain: " . DELCAMPE_TEXT_DOMAIN . "
 * Domain Path: " . DELCAMPE_DOMAIN_PATH . "
 *
 * @package WooCommerce_Delcampe_Integration
 * @version " . DELCAMPE_PLUGIN_VERSION . "
 */";
}

/**
 * Get the appropriate asset suffix based on debug mode
 * Returns '.min' for production or empty string for development
 * 
 * @return string Asset suffix
 * @since  1.6.2.1
 */
function delcampe_get_asset_suffix() {
    return DELCAMPE_USE_MINIFIED_ASSETS ? '.min' : '';
}

/**
 * Check if the plugin is running in debug mode
 * 
 * @return bool True if debug mode is enabled
 * @since  1.6.2.1
 */
function delcampe_is_debug_mode() {
    return DELCAMPE_DEBUG_MODE || (defined('WP_DEBUG') && WP_DEBUG);
}
