<?php
/**
 * Additional methods for Delcampe Profiles Admin
 * Version: 1.0.1.0
 *
 * Contains additional helper methods for the enhanced admin interface
 *
 * @package WooCommerce_Delcampe_Integration
 * @subpackage Admin
 * @since 1.0.1.0
 * @version 1.0.1.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Get WooCommerce categories hierarchy
 * 
 * @return array Categories array
 */
function delcampe_profiles_get_woo_categories_hierarchy() {
    $args = array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC',
    );
    
    return get_terms( $args );
}

/**
 * Render category options for select
 * 
 * @param array $categories Categories array
 * @param int   $selected   Selected category ID
 * @param int   $level      Indentation level
 * @return string HTML options
 */
function delcampe_profiles_render_category_options( $categories, $selected = 0, $level = 0 ) {
    $html = '';
    
    foreach ( $categories as $category ) {
        if ( $category->parent == 0 && $level == 0 ) {
            $html .= sprintf(
                '<option value="%d" %s>%s%s</option>',
                $category->term_id,
                selected( $selected, $category->term_id, false ),
                str_repeat( '&nbsp;&nbsp;', $level ),
                esc_html( $category->name )
            );
            
            // Get children
            $html .= delcampe_profiles_render_category_children( $categories, $category->term_id, $selected, $level + 1 );
        }
    }
    
    return $html;
}

/**
 * Render child categories
 * 
 * @param array $categories All categories
 * @param int   $parent_id  Parent category ID
 * @param int   $selected   Selected category ID
 * @param int   $level      Indentation level
 * @return string HTML options
 */
function delcampe_profiles_render_category_children( $categories, $parent_id, $selected = 0, $level = 1 ) {
    $html = '';
    
    foreach ( $categories as $category ) {
        if ( $category->parent == $parent_id ) {
            $html .= sprintf(
                '<option value="%d" %s>%s%s</option>',
                $category->term_id,
                selected( $selected, $category->term_id, false ),
                str_repeat( '&nbsp;&nbsp;', $level ),
                esc_html( $category->name )
            );
            
            // Recursive call for deeper levels
            $html .= delcampe_profiles_render_category_children( $categories, $category->term_id, $selected, $level + 1 );
        }
    }
    
    return $html;
}
