<?php
/**
 * Stamp Profile Fields Helper
 * Version: 1.0.2.0
 *
 * Provides stamp-specific field definitions and options for Delcampe profiles.
 * Contains all philatelic-specific attributes and settings.
 * 
 * Note: Translation functions removed from return arrays to prevent early loading.
 * Use the _translated() versions of functions when displaying to users.
 *
 * @package WooCommerce_Delcampe_Integration
 * @subpackage Profiles
 * @since 1.0.0.0
 * @version 1.0.2.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Get stamp-specific profile fields
 * 
 * Returns comprehensive array of stamp-related fields for profiles
 * 
 * @since 1.0.1.0
 * @return array Field definitions
 */
function delcampe_get_stamp_profile_fields() {
    return array(
        'listing_details' => array(
            'duration' => '30',  // Default 30 days for stamps
            'auto_renew' => '1',
            'listing_type' => 'FixedPrice',  // FixedPrice or Auction
            'price_adjustment' => '',
            'quantity_mode' => 'stock',
            'fixed_quantity' => '1',
            'currency' => get_woocommerce_currency(),
            'minimum_price' => '',
            'reserve_price' => '',
            'buy_now_price' => '',
            'image_selection' => 'all',
            'selected_images' => array(),
        ),
        
        'sync_settings' => array(
            'sync_title' => '1',
            'sync_description' => '1',
            'sync_price' => '1',
            'sync_quantity' => '1',
            'sync_images' => '1',
            'sync_attributes' => '1',
            'auto_sync' => '0',
            'sync_interval' => '24',
        ),
        
        'stamp_settings' => array(
            'default_condition' => 'Used',
            'catalog_prefix' => 'Michel',
            'add_catalog_number' => '1',
            'perforation_details' => '1',
            'watermark_info' => '1',
            'gum_condition' => '',
            'centering' => '',
            'grade' => '',
            'certificate' => '0',
            'certificate_details' => '',
            'expertized' => '0',
            'expertizer_name' => '',
        ),
        
        'shipping_settings' => array(
            'shipping_type' => 'Standard',
            'shipping_cost' => '2.50',
            'additional_item_cost' => '0.50',
            'combined_shipping' => '1',
            'ships_to' => 'Worldwide',
            'excluded_countries' => '',
            'handling_time' => '2',
            'return_policy' => '14',
            'insurance_optional' => '1',
            'insurance_cost' => '5.00',
        ),
        
        'payment_settings' => array(
            'payment_methods' => array('PayPal', 'BankTransfer'),
            'payment_deadline' => '7',
            'payment_instructions' => '',
            'bank_details' => '',
            'paypal_email' => '',
        ),
        
        'description_settings' => array(
            'template_type' => 'stamp_standard',
            'include_technical' => '1',
            'include_catalog_info' => '1',
            'include_condition_details' => '1',
            'include_shipping_info' => '1',
            'include_payment_terms' => '1',
            'include_guarantee' => '1',
            'custom_header' => '',
            'custom_footer' => '',
            'language' => 'en',
        ),
    );
}

/**
 * Get stamp condition options
 * 
 * @since 1.0.1.0
 * @return array Condition options
 */
function delcampe_get_stamp_conditions() {
    return array(
        'MNH' => 'Mint Never Hinged (MNH)',
        'MLH' => 'Mint Lightly Hinged (MLH)',
        'MH' => 'Mint Hinged (MH)',
        'Used' => 'Used',
        'CTO' => 'Cancelled to Order (CTO)',
        'FDC' => 'First Day Cover',
        'Mixed' => 'Mixed Condition',
    );
}

/**
 * Get catalog system options
 * 
 * @since 1.0.1.0
 * @return array Catalog systems
 */
function delcampe_get_catalog_systems() {
    return array(
        'Michel' => 'Michel',
        'Scott' => 'Scott',
        'Yvert' => 'Yvert & Tellier',
        'Stanley_Gibbons' => 'Stanley Gibbons',
        'Sassone' => 'Sassone',
        'Edifil' => 'Edifil',
        'Other' => 'Other',
    );
}

/**
 * Get gum condition options
 * 
 * @since 1.0.1.0
 * @return array Gum conditions
 */
function delcampe_get_gum_conditions() {
    return array(
        '' => '— Not Applicable —',
        'og' => 'Original Gum (OG)',
        'ng' => 'No Gum (NG)',
        'regum' => 'Regummed',
        'partial' => 'Partial Gum',
        'disturbed' => 'Disturbed Gum',
    );
}

/**
 * Get centering options
 * 
 * @since 1.0.1.0
 * @return array Centering options
 */
function delcampe_get_centering_options() {
    return array(
        '' => '— Not Specified —',
        'superb' => 'Superb',
        'xf' => 'Extra Fine (XF)',
        'vf' => 'Very Fine (VF)',
        'f' => 'Fine (F)',
        'avg' => 'Average',
    );
}

/**
 * Get grade options
 * 
 * @since 1.0.1.0
 * @return array Grade options
 */
function delcampe_get_grade_options() {
    return array(
        '' => '— Not Graded —',
        '100' => '100 (Gem)',
        '98' => '98 (Superb)',
        '95' => '95 (XF-Superb)',
        '90' => '90 (XF)',
        '85' => '85 (VF-XF)',
        '80' => '80 (VF)',
        '75' => '75 (F-VF)',
        '70' => '70 (F)',
    );
}

/**
 * Get shipping type options
 * 
 * @since 1.0.1.0
 * @return array Shipping types
 */
function delcampe_get_shipping_types() {
    return array(
        'Standard' => 'Standard Mail',
        'Registered' => 'Registered Mail',
        'Priority' => 'Priority Mail',
        'Express' => 'Express Mail',
        'Courier' => 'Courier Service',
    );
}

/**
 * Get payment method options
 * 
 * @since 1.0.1.0
 * @return array Payment methods
 */
function delcampe_get_payment_methods() {
    return array(
        'PayPal' => 'PayPal',
        'BankTransfer' => 'Bank Transfer',
        'Check' => 'Check/Cheque',
        'MoneyOrder' => 'Money Order',
        'Cash' => 'Cash (at own risk)',
        'Skrill' => 'Skrill',
        'Other' => 'Other',
    );
}

/**
 * Get description template types
 * 
 * @since 1.0.1.0
 * @return array Template types
 */
function delcampe_get_description_templates() {
    return array(
        'stamp_standard' => 'Standard Stamp Template',
        'stamp_detailed' => 'Detailed Stamp Template',
        'stamp_minimal' => 'Minimal Stamp Template',
        'custom' => 'Custom Template',
    );
}

/**
 * Get countries list for shipping
 * 
 * @since 1.0.1.0
 * @return array Countries
 */
function delcampe_get_shipping_countries() {
    return array(
        'Worldwide' => 'Worldwide',
        'Europe' => 'Europe Only',
        'EU' => 'European Union Only',
        'North_America' => 'North America',
        'Custom' => 'Custom List',
    );
}

/**
 * Get listing type options
 * 
 * @since 1.0.1.0
 * @return array Listing types
 */
function delcampe_get_listing_types() {
    return array(
        'FixedPrice' => 'Fixed Price',
        'Auction' => 'Auction',
        'BestOffer' => 'Best Offer',
    );
}

/**
 * Get currency options
 * 
 * @since 1.0.1.0
 * @return array Currencies
 */
function delcampe_get_currencies() {
    return array(
        'EUR' => 'EUR - Euro',
        'USD' => 'USD - US Dollar',
        'GBP' => 'GBP - British Pound',
        'CHF' => 'CHF - Swiss Franc',
        'CAD' => 'CAD - Canadian Dollar',
        'AUD' => 'AUD - Australian Dollar',
    );
}

/**
 * Get translated stamp conditions
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated stamp conditions
 */
function delcampe_get_stamp_conditions_translated() {
    $conditions = delcampe_get_stamp_conditions();
    $translated = array();
    foreach ($conditions as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated catalog systems
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated catalog systems
 */
function delcampe_get_catalog_systems_translated() {
    $systems = delcampe_get_catalog_systems();
    $translated = array();
    foreach ($systems as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated gum conditions
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated gum conditions
 */
function delcampe_get_gum_conditions_translated() {
    $conditions = delcampe_get_gum_conditions();
    $translated = array();
    foreach ($conditions as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated centering options
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated centering options
 */
function delcampe_get_centering_options_translated() {
    $options = delcampe_get_centering_options();
    $translated = array();
    foreach ($options as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated grade options
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated grade options
 */
function delcampe_get_grade_options_translated() {
    $grades = delcampe_get_grade_options();
    $translated = array();
    foreach ($grades as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated shipping types
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated shipping types
 */
function delcampe_get_shipping_types_translated() {
    $types = delcampe_get_shipping_types();
    $translated = array();
    foreach ($types as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated payment methods
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated payment methods
 */
function delcampe_get_payment_methods_translated() {
    $methods = delcampe_get_payment_methods();
    $translated = array();
    foreach ($methods as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated description templates
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated description templates
 */
function delcampe_get_description_templates_translated() {
    $templates = delcampe_get_description_templates();
    $translated = array();
    foreach ($templates as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated shipping countries
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated shipping countries
 */
function delcampe_get_shipping_countries_translated() {
    $countries = delcampe_get_shipping_countries();
    $translated = array();
    foreach ($countries as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated listing types
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated listing types
 */
function delcampe_get_listing_types_translated() {
    $types = delcampe_get_listing_types();
    $translated = array();
    foreach ($types as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}

/**
 * Get translated currencies
 * Use this when displaying options to users
 * 
 * @since 1.0.2.0
 * @return array Translated currencies
 */
function delcampe_get_currencies_translated() {
    $currencies = delcampe_get_currencies();
    $translated = array();
    foreach ($currencies as $key => $value) {
        $translated[$key] = __($value, 'wc-delcampe-integration');
    }
    return $translated;
}