<?php
// Load WordPress
require_once('/var/www/html/wp-load.php');

echo "Running Delcampe Resolver Directly...\n\n";

// Initialize the queue
$queue = Delcampe_Queue::get_instance();

// Check if method exists
if (!method_exists($queue, 'resolve_legacy_verified_items')) {
    echo "ERROR: resolve_legacy_verified_items method doesn't exist!\n";
    exit(1);
}

// Run legacy resolver
echo "Resolving legacy verified items...\n";
$resolved_legacy = $queue->resolve_legacy_verified_items(25);
echo "Resolved {$resolved_legacy} legacy items\n\n";

// Run queue resolver
echo "Resolving queue verifying items...\n";
$resolved_queue = $queue->resolve_ids_batch(25);
echo "Resolved {$resolved_queue} queue items\n\n";

echo "Done! Check logs at: /var/www/html/wp-content/delcampe-logs/delcampe-sync.log\n";
