<?php
/**
 * Settings Page Template for Delcampe Integration
 *
 * This file contains the HTML markup for the Delcampe Integration settings page.
 *
 * @package Delcampe_Integration
 * @since 1.0.0
 */
if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'wc-delcampe-integration' ) );
}
?>
<div class="wrap">
	<h1><?php esc_html_e( 'Delcampe Integration Settings', 'wc-delcampe-integration' ); ?></h1>
	<?php settings_errors(); ?>
	<form method="post" action="options.php">
		<?php
		// Output security fields for the registered setting.
		settings_fields( 'delcampe_integration_settings_group' );
		// Output setting sections and their fields.
		do_settings_sections( 'delcampe_integration_settings_page' );
		// Submit button.
		submit_button();
		?>
	</form>
</div>
