#!/usr/bin/php
<?php
/**
 * EMERGENCY: Disable all automatic syncing to stop API storms
 * v1.10.35.12
 */

require_once(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/wp-load.php');

echo "\n=== EMERGENCY: DISABLING AUTOMATIC SYNC ===\n";
echo "Version: 1.10.35.12\n";
echo "Time: " . current_time('Y-m-d H:i:s') . "\n\n";

// 1. Remove problematic cron jobs
$crons_to_remove = array(
    'delcampe_sync_prices_from_delcampe',
    'delcampe_process_batch_queue',
    'delcampe_process_sync_queue',
    'delcampe_master_sync',
    'delcampe_process_queue',
    'delcampe_check_processing_status',
    'delcampe_resolve_listing_ids'
);

echo "=== REMOVING CRON JOBS ===\n";
foreach ($crons_to_remove as $hook) {
    $timestamp = wp_next_scheduled($hook);
    if ($timestamp) {
        wp_unschedule_event($timestamp, $hook);
        wp_clear_scheduled_hook($hook);
        echo "✅ Removed: $hook\n";
    }
}

// 2. Disable auto sync settings
echo "\n=== DISABLING AUTO SYNC SETTINGS ===\n";
update_option('delcampe_auto_sync_prices', 'no');
update_option('delcampe_auto_sync_stock', 'no');
update_option('delcampe_auto_import_orders', 'no');
update_option('delcampe_master_sync_enabled', 'no');
update_option('delcampe_auto_sync_on_stock_change', 'no');
echo "✅ All auto-sync settings disabled\n";

// 3. Clear any stuck locks
echo "\n=== CLEARING STUCK LOCKS ===\n";
delete_transient('delcampe_batch_processing_lock');
delete_transient('delcampe_sync_processing_lock');
delete_transient('delcampe_reconciliation_lock');
delete_transient('delcampe_master_sync_lock');
echo "✅ All processing locks cleared\n";

// 4. Log the emergency action
delcampe_log('[EMERGENCY] Automatic sync disabled due to API storm - manual intervention required');

echo "\n✅ EMERGENCY MEASURES APPLIED!\n";
echo "\nAll automatic syncing has been disabled.\n";
echo "Stock and price updates must now be done manually from the admin interface.\n";
echo "\nTo re-enable specific features:\n";
echo "- Go to Delcampe → Settings\n";
echo "- Enable only what you need\n";
echo "- Monitor API usage carefully\n\n";