jQuery(document).ready(function($) {
    // Handle migration button click
    $('#migrate-btn').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        if (!confirm('Are you sure you want to migrate to the new queue system? This will migrate all pending items from the old system.')) {
            return;
        }
        
        $button.prop('disabled', true).text('Migrating...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'delcampe_queue_migrate',
                nonce: $('#delcampe_queue_nonce').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Migration completed successfully!');
                    location.reload();
                } else {
                    alert('Migration failed: ' + (response.data ? response.data : 'Unknown error'));
                    $button.prop('disabled', false).text(originalText);
                }
            },
            error: function(xhr, status, error) {
                alert('Migration failed: ' + error);
                $button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Handle rollback button click if present
    $('#rollback-btn').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        if (!confirm('Are you sure you want to rollback the migration? This will restore the old queue system data.')) {
            return;
        }
        
        $button.prop('disabled', true).text('Rolling back...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'delcampe_queue_rollback',
                nonce: $('#delcampe_queue_nonce').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Rollback completed successfully!');
                    location.reload();
                } else {
                    alert('Rollback failed: ' + (response.data ? response.data : 'Unknown error'));
                    $button.prop('disabled', false).text(originalText);
                }
            },
            error: function(xhr, status, error) {
                alert('Rollback failed: ' + error);
                $button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Auto-refresh stats every 30 seconds
    function refreshQueueStats() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'delcampe_queue_stats',
                nonce: $('#delcampe_queue_nonce').val()
            },
            success: function(response) {
                if (response.success && response.data) {
                    updateStatsDisplay(response.data);
                }
            }
        });
    }
    
    function updateStatsDisplay(stats) {
        if (stats.pending !== undefined) {
            $('#queue-pending').text(stats.pending);
        }
        if (stats.processing !== undefined) {
            $('#queue-processing').text(stats.processing);
        }
        if (stats.published !== undefined) {
            $('#queue-published').text(stats.published);
        }
        if (stats.errored !== undefined) {
            $('#queue-errored').text(stats.errored);
        }
    }
    
    // Refresh stats every 30 seconds if on queue page
    if ($('.delcampe-queue-stats').length) {
        setInterval(refreshQueueStats, 30000);
    }
});