<?php
/**
 * Image URL Filter for Development Testing
 * 
 * This filter replaces dev site image URLs with production URLs
 * to work around redirect issues on the dev server.
 * 
 * @package Delcampe_Sync
 * @since 1.10.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Filter image URLs for Delcampe API
 * 
 * When running on dev site, replace image URLs with production URLs
 * so Delcampe can successfully fetch the images.
 */
add_filter('delcampe_product_images', function($images, $product, $profile) {
    // Only apply on dev site
    if (strpos(home_url(), 'dev.fdstamps.com') === false) {
        return $images;
    }
    
    // Replace dev URLs with production URLs
    $production_domain = 'https://fdstamps.com'; // Adjust if different
    $dev_domain = home_url();
    
    $filtered_images = array();
    foreach ($images as $image_url) {
        // Replace dev domain with production domain
        $production_url = str_replace($dev_domain, $production_domain, $image_url);
        $filtered_images[] = $production_url;
    }
    
    return $filtered_images;
}, 10, 3);