<?php
/**
 * License Page Template
 *
 * @package WC_Delcampe_Integration
 * @version 1.10.8.0
 * @since   1.8.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Check if we're actually using trial (no real license active)
$license_type = $license_manager->get_license_type();
$is_trial = ($license_type === 'trial');
$trial_days_remaining = $license_manager->get_trial_days_remaining();
$trial_listings = $license_manager->get_trial_listings_count();

// Define feature structure without translations
$features_structure = array(
    'listings' => array(
        'label_key' => 'Product Listings',
        'description_key' => 'Create and manage Delcampe listings'
    ),
    'profiles' => array(
        'label_key' => 'Listing Profiles',
        'description_key' => 'Save listing settings as reusable profiles'
    ),
    'sync' => array(
        'label_key' => 'Inventory Sync',
        'description_key' => 'Real-time stock synchronization'
    ),
    'orders' => array(
        'label_key' => 'Order Management',
        'description_key' => 'Import and manage Delcampe orders'
    ),
    'inventory' => array(
        'label_key' => 'Inventory Management',
        'description_key' => 'Advanced inventory tracking and alerts'
    ),
    'templates' => array(
        'label_key' => 'Custom Templates',
        'description_key' => 'Create custom listing templates',
        'min_license' => 'standard'
    ),
    'bulk_operations' => array(
        'label_key' => 'Bulk Operations',
        'description_key' => 'Manage multiple listings at once',
        'min_license' => 'basic'
    ),
    'multi_account' => array(
        'label_key' => 'Multiple Accounts',
        'description_key' => 'Connect multiple Delcampe accounts',
        'min_license' => 'professional'
    ),
    'automation' => array(
        'label_key' => 'Automation Rules',
        'description_key' => 'Automate listing and pricing tasks',
        'min_license' => 'standard'
    ),
    'api_access' => array(
        'label_key' => 'REST API Access',
        'description_key' => 'Integrate with external systems',
        'min_license' => 'professional'
    ),
    'priority_support' => array(
        'label_key' => 'Priority Support',
        'description_key' => 'Get help faster with priority support',
        'min_license' => 'professional'
    )
);

?>

<div class="wrap delcampe-license-wrap">
    <h1><?php _e('WooCommerce Delcampe Integration - License Management', 'wc-delcampe-integration'); ?></h1>
    
    <?php if (isset($_GET['notice']) && $_GET['notice'] === 'required'): ?>
        <div class="notice notice-error">
            <p><?php _e('A valid license is required to use WooCommerce Delcampe Integration.', 'wc-delcampe-integration'); ?></p>
        </div>
    <?php endif; ?>
    
    <div class="delcampe-license-container">
        <div class="license-main">
            <!-- License Status Card -->
            <div class="license-status-card <?php echo $is_valid ? 'active' : 'inactive'; ?>">
                <div class="status-header">
                    <div class="status-indicator">
                        <?php if ($is_valid): ?>
                            <span class="dashicons dashicons-yes-alt"></span>
                            <span class="status-text">
                                <?php if ($is_trial): ?>
                                    <?php _e('Free Trial Active', 'wc-delcampe-integration'); ?>
                                <?php else: ?>
                                    <?php _e('Active License', 'wc-delcampe-integration'); ?>
                                <?php endif; ?>
                            </span>
                        <?php else: ?>
                            <span class="dashicons dashicons-warning"></span>
                            <span class="status-text"><?php _e('No Active License', 'wc-delcampe-integration'); ?></span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($is_trial): ?>
                        <div class="license-type-badge trial">
                            Trial
                        </div>
                    <?php elseif ($license): ?>
                        <div class="license-type-badge <?php echo esc_attr($license->license_type); ?>">
                            <?php echo ucfirst($license->license_type); ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if ($is_trial): ?>
                    <div class="license-info">
                        <div class="info-row">
                            <span class="info-label"><?php _e('Trial Status:', 'wc-delcampe-integration'); ?></span>
                            <span>
                                <?php if ($trial_days_remaining > 0): ?>
                                    <?php printf(_n('%d day remaining', '%d days remaining', $trial_days_remaining, 'wc-delcampe-integration'), $trial_days_remaining); ?>
                                <?php else: ?>
                                    <?php _e('Trial expired', 'wc-delcampe-integration'); ?>
                                <?php endif; ?>
                            </span>
                        </div>
                        
                        <div class="info-row">
                            <span class="info-label"><?php _e('Listings Used:', 'wc-delcampe-integration'); ?></span>
                            <span><?php echo $trial_listings['used']; ?> / <?php echo $trial_listings['limit']; ?></span>
                        </div>
                        
                        <div class="info-row">
                            <span class="info-label"><?php _e('Features:', 'wc-delcampe-integration'); ?></span>
                            <span><?php _e('Full access for 14 days, limited to 5 listings', 'wc-delcampe-integration'); ?></span>
                        </div>
                    </div>
                <?php elseif ($license): ?>
                    <div class="license-info">
                        <div class="info-row">
                            <span class="info-label"><?php _e('License Key:', 'wc-delcampe-integration'); ?></span>
                            <code class="license-key-display">
                                <?php echo substr($license->license_key, 0, 4); ?>-****-****-<?php echo substr($license->license_key, -4); ?>
                            </code>
                        </div>
                        
                        <div class="info-row">
                            <span class="info-label"><?php _e('Activated:', 'wc-delcampe-integration'); ?></span>
                            <span><?php echo date_i18n(get_option('date_format'), strtotime($license->activation_date)); ?></span>
                        </div>
                        
                        <?php if ($license->expiration_date): ?>
                            <?php 
                            $days_remaining = floor((strtotime($license->expiration_date) - time()) / 86400);
                            $expiry_class = $days_remaining <= 30 ? 'expiring-soon' : '';
                            ?>
                            <div class="info-row <?php echo $expiry_class; ?>">
                                <span class="info-label"><?php _e('Expires:', 'wc-delcampe-integration'); ?></span>
                                <span>
                                    <?php echo date_i18n(get_option('date_format'), strtotime($license->expiration_date)); ?>
                                    <?php if ($days_remaining > 0): ?>
                                        (<?php printf(_n('%d day remaining', '%d days remaining', $days_remaining, 'wc-delcampe-integration'), $days_remaining); ?>)
                                    <?php endif; ?>
                                </span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="info-row">
                            <span class="info-label"><?php _e('Activations:', 'wc-delcampe-integration'); ?></span>
                            <span><?php echo $license->activation_count; ?> / <?php echo $license->activation_limit; ?></span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- License Form -->
            <div class="license-form-card">
                <?php if ($is_trial): ?>
                    <div class="trial-upgrade">
                        <h2><?php _e('Upgrade from Trial', 'wc-delcampe-integration'); ?></h2>
                        <p><?php _e('Your free trial gives you full access to all features for 14 days, limited to 5 listings.', 'wc-delcampe-integration'); ?></p>
                        
                        <?php if ($trial_days_remaining <= 3): ?>
                            <div class="notice notice-warning inline">
                                <p>
                                    <strong><?php _e('Trial ending soon!', 'wc-delcampe-integration'); ?></strong>
                                    <?php printf(_n('Only %d day remaining.', 'Only %d days remaining.', $trial_days_remaining, 'wc-delcampe-integration'), $trial_days_remaining); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        
                        <form id="delcampe-activate-license" method="post">
                            <div class="form-group">
                                <label for="license-key"><?php _e('Enter License Key to Upgrade', 'wc-delcampe-integration'); ?></label>
                                <input type="text" 
                                       id="license-key" 
                                       name="license_key"
                                       class="regular-text license-key-input"
                                       placeholder="XXXX-XXXX-XXXX-XXXX" 
                                       pattern="[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}"
                                       maxlength="19" />
                                <p class="description">
                                    <?php _e('Enter your license key to unlock unlimited features.', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="button button-primary button-hero">
                                    <span class="dashicons dashicons-upload"></span>
                                    <?php _e('Upgrade Now', 'wc-delcampe-integration'); ?>
                                </button>
                                <a href="https://www.sos-tech.ca/delcampe-sync-pricing/" target="_blank" class="button button-secondary">
                                    <span class="dashicons dashicons-cart"></span>
                                    <?php _e('View Pricing', 'wc-delcampe-integration'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                <?php elseif (!$is_valid): ?>
                    <div class="activate-license">
                        <h2><?php _e('Activate Your License', 'wc-delcampe-integration'); ?></h2>
                        <p><?php _e('Enter your license key below to unlock all features and start using WooCommerce Delcampe Integration.', 'wc-delcampe-integration'); ?></p>
                        
                        <form id="delcampe-activate-license" method="post">
                            <div class="form-group">
                                <label for="license-key"><?php _e('License Key', 'wc-delcampe-integration'); ?></label>
                                <input type="text" 
                                       id="license-key" 
                                       name="license_key"
                                       class="regular-text license-key-input"
                                       placeholder="XXXX-XXXX-XXXX-XXXX" 
                                       pattern="[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}"
                                       maxlength="19"
                                       required />
                                <p class="description">
                                    <?php _e('Enter your license key exactly as provided. Format: XXXX-XXXX-XXXX-XXXX', 'wc-delcampe-integration'); ?>
                                </p>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="button button-primary button-hero">
                                    <span class="dashicons dashicons-admin-network"></span>
                                    <?php _e('Activate License', 'wc-delcampe-integration'); ?>
                                </button>
                            </div>
                        </form>
                        
                        <div class="license-help">
                            <p>
                                <?php _e("Don't have a license key?", 'wc-delcampe-integration'); ?>
                                <a href="https://www.sos-tech.ca/delcampe-sync-pricing/" target="_blank"><?php _e('Purchase one here', 'wc-delcampe-integration'); ?></a>
                            </p>
                            <p>
                                <?php _e("Your trial has expired. Purchase a license to continue using the plugin.", 'wc-delcampe-integration'); ?>
                            </p>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="manage-license">
                        <h2><?php _e('License Actions', 'wc-delcampe-integration'); ?></h2>
                        
                        <div class="license-actions">
                            <button type="button" id="check-license" class="button">
                                <span class="dashicons dashicons-update"></span>
                                <?php _e('Check License Status', 'wc-delcampe-integration'); ?>
                            </button>
                            
                            <button type="button" id="deactivate-license" class="button button-secondary">
                                <span class="dashicons dashicons-no"></span>
                                <?php _e('Deactivate License', 'wc-delcampe-integration'); ?>
                            </button>
                            
                            <?php if ($license && $license->expiration_date): ?>
                                <?php $days_remaining = floor((strtotime($license->expiration_date) - time()) / 86400); ?>
                                <?php if ($days_remaining <= 30 && $days_remaining > 0): ?>
                                    <a href="https://yourwebsite.com/renew" target="_blank" class="button button-primary">
                                        <span class="dashicons dashicons-cart"></span>
                                        <?php _e('Renew License', 'wc-delcampe-integration'); ?>
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        
                        <div class="license-help">
                            <p><?php _e('Need to change your license or upgrade?', 'wc-delcampe-integration'); ?> 
                            <a href="https://yourwebsite.com/account" target="_blank"><?php _e('Manage your licenses', 'wc-delcampe-integration'); ?></a></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Feature Access Sidebar -->
        <div class="license-sidebar">
            <div class="feature-access-card">
                <h2><?php _e('Feature Access', 'wc-delcampe-integration'); ?></h2>
                <p><?php _e('Your license includes access to the following features:', 'wc-delcampe-integration'); ?></p>
                
                <div class="feature-list">
                    <?php foreach ($features_structure as $feature_key => $feature): ?>
                        <?php 
                        $has_access = delcampe_has_feature($feature_key);
                        $limit = delcampe_get_feature_limit($feature_key);
                        ?>
                        <div class="feature-item <?php echo $has_access ? 'enabled' : 'disabled'; ?>">
                            <div class="feature-header">
                                <span class="feature-icon dashicons dashicons-<?php echo $has_access ? 'yes' : 'no'; ?>"></span>
                                <span class="feature-name"><?php _e($feature['label_key'], 'wc-delcampe-integration'); ?></span>
                            </div>
                            <div class="feature-details">
                                <p class="feature-description"><?php _e($feature['description_key'], 'wc-delcampe-integration'); ?></p>
                                <?php if ($has_access && is_numeric($limit)): ?>
                                    <p class="feature-limit">
                                        <?php printf(__('Limit: %d', 'wc-delcampe-integration'), $limit); ?>
                                        <?php
                                        if ($feature_key === 'listings') {
                                            $remaining = delcampe_get_remaining_listings();
                                            if (is_numeric($remaining)) {
                                                printf(__(' (%d remaining)', 'wc-delcampe-integration'), $remaining);
                                            }
                                        } elseif ($feature_key === 'profiles') {
                                            $remaining = delcampe_get_remaining_profiles();
                                            if (is_numeric($remaining)) {
                                                printf(__(' (%d remaining)', 'wc-delcampe-integration'), $remaining);
                                            }
                                        }
                                        ?>
                                    </p>
                                <?php elseif ($has_access && $limit === 'unlimited'): ?>
                                    <p class="feature-limit unlimited"><?php _e('Unlimited', 'wc-delcampe-integration'); ?></p>
                                <?php elseif (!$has_access && isset($feature['min_license'])): ?>
                                    <p class="feature-requirement">
                                        <?php printf(__('Requires %s license', 'wc-delcampe-integration'), ucfirst($feature['min_license'])); ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <?php if (!$is_valid || ($license && $license->license_type !== 'enterprise')): ?>
                    <div class="upgrade-prompt">
                        <a href="https://yourwebsite.com/pricing" target="_blank" class="button button-primary">
                            <?php _e('View Upgrade Options', 'wc-delcampe-integration'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.delcampe-license-wrap {
    max-width: 1200px;
    margin: 20px 0;
}

.delcampe-license-container {
    display: flex;
    gap: 20px;
    margin-top: 20px;
}

.license-main {
    flex: 1;
    min-width: 0;
}

.license-sidebar {
    width: 350px;
    flex-shrink: 0;
}

/* Status Card */
.license-status-card {
    background: #fff;
    border: 2px solid #ddd;
    border-radius: 8px;
    padding: 25px;
    margin-bottom: 20px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.license-status-card.active {
    border-color: #46b450;
}

.license-status-card.inactive {
    border-color: #dc3232;
}

.status-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.status-indicator {
    display: flex;
    align-items: center;
    font-size: 20px;
    font-weight: 600;
}

.status-indicator .dashicons {
    font-size: 28px;
    width: 28px;
    height: 28px;
    margin-right: 10px;
}

.license-status-card.active .dashicons-yes-alt {
    color: #46b450;
}

.license-status-card.inactive .dashicons-warning {
    color: #dc3232;
}

.license-type-badge {
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
    text-transform: uppercase;
}

.license-type-badge.trial {
    background: #00a0d2;
    color: #fff;
}

.license-type-badge.basic {
    background: #2271b1;
    color: #fff;
}

.license-type-badge.standard {
    background: #00a32a;
    color: #fff;
}

.license-type-badge.professional {
    background: #8e44ad;
    color: #fff;
}

.license-type-badge.enterprise {
    background: #f39c12;
    color: #fff;
}

/* License Info */
.license-info {
    display: grid;
    gap: 12px;
}

.info-row {
    display: flex;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid #f0f0f1;
}

.info-row:last-child {
    border-bottom: none;
}

.info-label {
    font-weight: 600;
    min-width: 120px;
    color: #50575e;
}

.license-key-display {
    font-family: monospace;
    font-size: 14px;
    background: #f0f0f1;
    padding: 4px 8px;
    border-radius: 4px;
}

.info-row.expiring-soon {
    color: #d63638;
}

/* License Form Card */
.license-form-card {
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 25px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.license-form-card h2 {
    margin-top: 0;
    margin-bottom: 15px;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
}

.license-key-input {
    width: 100%;
    max-width: 400px;
    padding: 8px 12px;
    font-size: 16px;
    font-family: monospace;
    text-transform: uppercase;
}

.form-actions {
    margin-top: 20px;
}

.button-hero {
    height: auto;
    padding: 12px 24px;
    font-size: 16px;
}

.button-hero .dashicons {
    margin-right: 8px;
    font-size: 20px;
    vertical-align: middle;
}

.license-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.license-actions .button {
    display: inline-flex;
    align-items: center;
}

.license-actions .dashicons {
    margin-right: 5px;
}

.license-help {
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #f0f0f1;
}

/* Feature Access Card */
.feature-access-card {
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 25px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.feature-access-card h2 {
    margin-top: 0;
    margin-bottom: 10px;
}

.feature-list {
    margin-top: 20px;
}

.feature-item {
    padding: 15px;
    margin-bottom: 10px;
    border: 1px solid #e5e5e5;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.feature-item.enabled {
    background: #f0f8ff;
    border-color: #2271b1;
}

.feature-item.disabled {
    background: #f5f5f5;
    opacity: 0.7;
}

.feature-header {
    display: flex;
    align-items: center;
    margin-bottom: 8px;
}

.feature-icon {
    font-size: 20px;
    width: 20px;
    height: 20px;
    margin-right: 10px;
}

.feature-item.enabled .feature-icon {
    color: #00a32a;
}

.feature-item.disabled .feature-icon {
    color: #787c82;
}

.feature-name {
    font-weight: 600;
    font-size: 15px;
}

.feature-description {
    margin: 5px 0;
    font-size: 13px;
    color: #50575e;
}

.feature-limit {
    font-size: 12px;
    color: #2271b1;
    font-weight: 600;
}

.feature-limit.unlimited {
    color: #00a32a;
}

.feature-requirement {
    font-size: 12px;
    color: #d63638;
    font-style: italic;
}

.upgrade-prompt {
    margin-top: 20px;
    text-align: center;
    padding-top: 20px;
    border-top: 1px solid #f0f0f1;
}

.trial-upgrade .notice.inline {
    margin: 15px 0;
}

.trial-upgrade .form-actions {
    display: flex;
    gap: 10px;
    align-items: center;
}

/* Responsive */
@media (max-width: 782px) {
    .delcampe-license-container {
        flex-direction: column;
    }
    
    .license-sidebar {
        width: 100%;
    }
    
    .status-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .license-actions {
        flex-direction: column;
    }
    
    .license-actions .button {
        width: 100%;
        justify-content: center;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // Activate license
    $('#delcampe-activate-license').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $button = $form.find('button[type="submit"]');
        var $input = $('#license-key');
        var licenseKey = $input.val();
        
        // Disable form
        $button.prop('disabled', true).text('<?php _e('Activating...', 'wc-delcampe-integration'); ?>');
        $input.prop('disabled', true);
        
        // Clear any existing notices
        $('.notice').remove();
        
        // Make AJAX request
        $.post(ajaxurl, {
            action: 'delcampe_activate_license',
            license_key: licenseKey,
            nonce: '<?php echo wp_create_nonce('delcampe_license_nonce'); ?>'
        })
        .done(function(response) {
            if (response.success) {
                // Show success message
                $('<div class="notice notice-success"><p>' + response.message + '</p></div>')
                    .insertBefore('.delcampe-license-container');
                
                // Reload page to show activated state
                setTimeout(function() {
                    location.reload();
                }, 1500);
            } else {
                // Show error message
                $('<div class="notice notice-error"><p>' + response.message + '</p></div>')
                    .insertBefore('.delcampe-license-container');
                
                // Re-enable form
                $button.prop('disabled', false).html('<span class="dashicons dashicons-admin-network"></span> <?php _e('Activate License', 'wc-delcampe-integration'); ?>');
                $input.prop('disabled', false).focus();
            }
        })
        .fail(function() {
            // Show error message
            $('<div class="notice notice-error"><p><?php _e('An error occurred. Please try again.', 'wc-delcampe-integration'); ?></p></div>')
                .insertBefore('.delcampe-license-container');
            
            // Re-enable form
            $button.prop('disabled', false).html('<span class="dashicons dashicons-admin-network"></span> <?php _e('Activate License', 'wc-delcampe-integration'); ?>');
            $input.prop('disabled', false);
        });
    });
    
    // Check license
    $('#check-license').on('click', function() {
        var $button = $(this);
        $button.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> <?php _e('Checking...', 'wc-delcampe-integration'); ?>');
        
        $.post(ajaxurl, {
            action: 'delcampe_check_license',
            nonce: '<?php echo wp_create_nonce('delcampe_license_nonce'); ?>'
        })
        .done(function(response) {
            var message = response.valid 
                ? '<?php _e('License is valid and active!', 'wc-delcampe-integration'); ?>' 
                : '<?php _e('License check failed. Please try again.', 'wc-delcampe-integration'); ?>';
            
            $('<div class="notice notice-' + (response.valid ? 'success' : 'error') + ' is-dismissible"><p>' + message + '</p></div>')
                .insertBefore('.delcampe-license-container');
            
            if (!response.valid) {
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        })
        .always(function() {
            $button.prop('disabled', false).html('<span class="dashicons dashicons-update"></span> <?php _e('Check License Status', 'wc-delcampe-integration'); ?>');
        });
    });
    
    // Deactivate license
    $('#deactivate-license').on('click', function() {
        if (!confirm('<?php _e('Are you sure you want to deactivate this license? You can reactivate it later.', 'wc-delcampe-integration'); ?>')) {
            return;
        }
        
        var $button = $(this);
        $button.prop('disabled', true).html('<span class="dashicons dashicons-no"></span> <?php _e('Deactivating...', 'wc-delcampe-integration'); ?>');
        
        $.post(ajaxurl, {
            action: 'delcampe_deactivate_license',
            nonce: '<?php echo wp_create_nonce('delcampe_license_nonce'); ?>'
        })
        .done(function(response) {
            if (response.success) {
                $('<div class="notice notice-success"><p>' + response.message + '</p></div>')
                    .insertBefore('.delcampe-license-container');
                
                setTimeout(function() {
                    location.reload();
                }, 1500);
            } else {
                $('<div class="notice notice-error"><p>' + response.message + '</p></div>')
                    .insertBefore('.delcampe-license-container');
                
                $button.prop('disabled', false).html('<span class="dashicons dashicons-no"></span> <?php _e('Deactivate License', 'wc-delcampe-integration'); ?>');
            }
        })
        .fail(function() {
            $('<div class="notice notice-error"><p><?php _e('An error occurred. Please try again.', 'wc-delcampe-integration'); ?></p></div>')
                .insertBefore('.delcampe-license-container');
            
            $button.prop('disabled', false).html('<span class="dashicons dashicons-no"></span> <?php _e('Deactivate License', 'wc-delcampe-integration'); ?>');
        });
    });
    
    // Auto-format license key input
    $('#license-key').on('input', function() {
        var value = $(this).val().toUpperCase().replace(/[^A-Z0-9]/g, '');
        var formatted = value.match(/.{1,4}/g);
        if (formatted) {
            $(this).val(formatted.join('-').substr(0, 19));
        }
    });
    
    // Add spinning animation
    $('<style>')
        .text('@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } } .dashicons.spin { animation: spin 1s linear infinite; }')
        .appendTo('head');
});
</script>